<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AllegroCategoryItemAttributes
 *
 * @ORM\Table(name="allegro_category_item_attributes")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\AllegroCategoryItemAttributesRepository")
 */
class AllegroCategoryItemAttributes
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var string $values - tablica rozdzielona |
     *
     * @ORM\Column(name="value", type="string", length=255)
     */
    private $value;

    /**
     * @var integer $item_id
     *
     * @ORM\Column(name="item_id", type="integer")
     */
    private $item_id;

    /**
     * @ORM\ManyToOne(targetEntity="AllegroCategoryItem",inversedBy="attributes")
     * @ORM\JoinColumn(name="item_id", referencedColumnName="id")
     */
    private $item;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return AllegroCategoryItemAttributes
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set value
     *
     * @param string $value
     * @return AllegroCategoryItemAttributes
     */
    public function setValue($value)
    {
        $this->value = $value;
    
        return $this;
    }

    /**
     * Get value
     *
     * @return string 
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Set item_id
     *
     * @param integer $itemId
     * @return AllegroCategoryItemAttributes
     */
    public function setItemId($itemId)
    {
        $this->item_id = $itemId;
    
        return $this;
    }

    /**
     * Get item_id
     *
     * @return integer 
     */
    public function getItemId()
    {
        return $this->item_id;
    }

    /**
     * Set item
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $item
     * @return AllegroCategoryItemAttributes
     */
    public function setItem(\Import\ApiBundle\Entity\AllegroCategoryItem $item = null)
    {
        $this->item = $item;
    
        return $this;
    }

    /**
     * Get item
     *
     * @return \Import\ApiBundle\Entity\AllegroCategoryItem 
     */
    public function getItem()
    {
        return $this->item;
    }
}